define([
    "dojo/_base/declare",
    "require",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dijit/_WidgetsInTemplateMixin",
    "dojo/text!./resources/LayerSwitcherTemplate.html",
    "./LayerCheckBox",
    "./LayerRadioButton",
    "app/view/Container" ],

function(declare, require, _WidgetBase, _TemplatedMixin,
    _WidgetsInTemplateMixin, templateString, LayerCheckBox, LayerRadioButton) {

    return declare([ _WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin ], {
        templateString : templateString,
        requireScope : require,
        _layers : null,
        _map : null,

        infoLayersLabel : "Layers",
        _setInfoLayersLabelAttr : {
            node : "infoLayersLabelNode",
            type : "innerHTML"
        },

        baseLayersLabel : "Base",
        _setBaseLayersLabelAttr : {
            node : "baseLayersLabelNode",
            type : "innerHTML"
        },

        constructor : function(options) {
            options = options || {};

            if (!options.map)
                throw new Error("The map is required");

            this._map = options.map;

            if (options.layers && options.layers instanceof Array)
                this._layers = options.layers;
            else
                this._layers = [];

            // this.baseLayersLabel = "Base";

        },

        postCreate : function() {
            this.inherited(arguments);

            var pending = [];

            for ( var i in this._layers) {
                if (this._layers[i].get("layerType") != "base")
                    pending.push(this._layers[i]);
                else
                    this._addLayer(this._layers[i]);
            }

            for ( var i in pending)
                this._addLayer(pending[i]);
        },

        _addLayer : function(layer) {
            this._map.addLayer(layer);

            if (layer.get("layerType") === "base") {
                this.baseLayersContainer.addChild(new LayerRadioButton({
                    layer : layer
                }));
            } else {
                this.infoLayersContainer.addChild(new LayerCheckBox({
                    layer : layer
                }));
            }
        },

    });
});