define([ "./declare-style", "dojo/_base/declare", "ol", "implab/safe" ],

function(declare, dojoDeclare, ol, safe) {
    return declare([], {
        _cache : null,
        _getKey : null,
        _getZoom : null,
        
        defaultStyle : null,
        
        style : null,
        
        styleFunction : null,
        
        filter : null,

        constructor : function(opts) {
            if (opts)
                dojoDeclare.safeMixin(this, opts);

            this._cache = {};

            if (this.zoom) {
                if (this.zoom instanceof Function) {
                    this._getZoom = this.zoom;
                } else {
                    var levels = [], max = "max";
                    for ( var p in this.zoom) {
                        if (safe.isNumber(this.zoom[p]))
                            levels.push({
                                name : p,
                                zoom : Number(this.zoom[p])
                            });
                        else if (this.zoom[p] == "max")
                            max = p;
                    }

                    levels.sort(function(x, y) {
                        return x.zoom - y.zoom;
                    });

                    this.zoomMax = max;
                    this.zoomLevels = levels;

                    this._getZoom = function(z) {
                        for (var i = 0; i < levels.length; i++) {
                            if (z <= levels[i].zoom)
                                return levels[i].name;
                        }
                        return max;
                    };
                }
            } else {
                this._getZoom = function(z) {
                    return "max";
                };
            }

            if (this.key) {
                if (this.key instanceof Function) {
                    this._getKey = this.key;
                } else if (typeof this.key === "string") {
                    this._getKey = function(ft) {
                        return ft.get(this.key);
                    };
                } else {
                    this._getKey = function(ft, z) {
                        var k = this.key[z];
                        if (k instanceof Function)
                            return k.call(this, ft, z);
                        else if (typeof k == "string")
                            return ft.get(k);
                        else
                            return this.defaultStyle;
                    };
                }
            } else {
                this._getKey = function() {
                    return this.defaultStyle;
                };
            }

            if (this.style) {
                if (this.style instanceof Function) {
                    this._style = this.style;
                } else {
                    this._style = function(ft, res, key, zoom) {
                        var s = this.style[zoom];
                        return s && (s instanceof Function) ? s.apply(
                            this,
                            arguments) : s;
                    };
                }
            }
        },

        getFeatureStyle : function(ft, res) {
            safe.argumentNotNull(ft, "ft");
            
            if (this.filter && this.filter(ft) === false)
                return null;

            var z = this._getZoom(res);
            var k = this._getKey(ft, z);

            var cid = [ k, z ].join('-');

            var style = this._cache[cid];
            if (!style) {
                style = this._style ? this._style(ft, res, k, z) : null;
                this._cache[cid] = style;
            }


            return safe.isNull(style) || style instanceof Array ? style : [ style ];
        }

    });
});