define([
    "dojo/_base/declare",
    "implab/safe",
    "implab/components/ActivationController",
    "./ToolType" ],

function(declare, safe, ActivationController, ToolType) {
    return declare([ ActivationController ], {
        _stack : null,
        _tools : null,

        constructor : function() {
            this._stack = new Array();
            this._tools = new Array();
        },

        activate : function(tool) {
            safe.argumentNotNull(tool, "tool");

            var me = this, current = me.getCurrent();

            return this.inherited(arguments).then(function(success) {
                if (success) {
                    if (tool.toolType == ToolType.Oneshot && current)
                        me._stack.push(current);
                    else
                        me._stack = [];
                }
                return success;
            });
        },

        deactivate : function() {
            var me = this;
            return me.inherited(arguments).then(function(success) {
                if (success && me._stack.length)
                    return me.activate(me._stack.pop());

                return success;
            });
        }
    });
});