define([
    "dojo/_base/declare",
    "implab/safe",
    "./MeasureToolBase",
    "implab/text/format",
    "dojo/i18n!./format/nls/units",
    "ol" ],

function(declare, safe, MeasureToolBase, format, units, ol) {
    return declare([ MeasureToolBase ], {

        isGeodesic : true,

        units : 'metric',
        
        constructor : function(opts) {
            if (opts)
                safe.mixin(this,opts,["isGeodesic", "units"]);
        },

        _createDraw : function(source) {
            return new ol.interaction.Draw(
                {
                    source : source,
                    type : "LineString",
                    style : this.drawStyle
                });
        },

        _formatTooltip : function(sketch, proj) {
            var length = 0;
            if (this.isGeodesic) {
                var points = sketch.getGeometry().getCoordinates();
                var t = ol.proj.getTransform(proj, "EPSG:4326");
                for (var i = 0; i < points.length - 1; i++) {
                    length += this.wgs84Sphere.haversineDistance(
                        t(points[i]),
                        t(points[i + 1]));
                }
            } else {
                length = sketch.getGeometry().getLength();
            }

            var mpu, unitName;
            switch (this.units) {
                case "nautical":
                    mpu = 1852;
                    unitName = units.nmiles;
                    break;
                default:
                    mpu = 1000;
                    unitName = units.kilometers;
            }

            if (length >= mpu) {
                return format("{0:#.0#}{1}", length / mpu, unitName);
            } else {
                return format("{0:#0.0#}{1}", length, units.meters);
            }
        }

    });
});