﻿define([
    "implab/text/template-compile",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "ol"],
    function (compile, declare, lang, ol) {
        return declare([ol.layer.Layer], {            

            name: null,

            displayName: null,

            identifyResultTemplate: null,

            searchResultTemplate: null,

            constructor: function () {
                lang.mixin(this, arguments[0]);
                var identifyCompiledTemplate = null, searchCompiledTemplate = null;
                if (this.identifyResultTemplate) {
                    identifyCompiledTemplate = compile(this.identifyResultTemplate);
                }
                if (this.searchResultTemplate) {
                    searchCompiledTemplate = compile(this.searchResultTemplate);
                }
            },

            /** Возвращает массив строк, каждая строка - результат поиска  приведенный к шаблонному виду
                @options {Object}
                    @str {String} поисковая строка
                    @bbox {Object} bound box, в рамках которого осуществлять поиск
            */
            getSearchResult: function (options) {
                console.warn("Метод необходимо переопределить для для слоя конкретного типа!");
            },
            /** Возвращает массив строк, каждая строка - результат идентификации приведенный к шаблонному виду
                @options {Object}
                    @coordinates {Array} массив описывающий координаты точки идентификации                    
            */
            getItentifyResult: function (coordinates) {
                console.warn("Метод необходимо переопределить для для слоя конкретного типа!");
            }
        });
    })