﻿define([
        "dijit/layout/ContentPane",
        "dojo/_base/declare",
        "dojo/Deferred",
        "dojo/dom-construct",
        "dojo/dom-class",
        "dojo/on",
        "dojo/promise/all",
        "dojo/when",
        "implab/safe",
        "ol",
        "./listen",
        "./IdentifyGroup",
        "./_ToolBase",
        "./PopupContainer"
    ],

    function (
        ContentPane,
        declare,
        Deffered,
        domConstruct,
        domClass,
        on,
        promiseAll,
        when,
        safe,
        ol,
        listen,
        IdentifyGroup,
        _ToolBase,
        PopupContainer) {
        return declare([_ToolBase], {
            /**
             * массив обработчиков openLayers, которые необходимо удалить при
             * деактивации
             */
            _handlers: null,
            /**
             * widget карты
             */
            _map: null,
            /**
             * openLayers map
             */
            _olMap: null,
            /**
             * Массив overlays содержащих popupContainers
             */
            _popupOverlays: null,
            /**
             * Массив popups контейнеров
             */
            _popupContainers: null,
            /**
             * Режим работы инструмента идентификации
             * 
             * @value {String} "single"||"multiple"
             */
            mode: null,
            /**
             * Режимы
             */
            appManager: null,

            constructor: function (options) {
                safe.argumentNotNull(options, "options");
                safe.argumentNotNull(options.map, "options.map");
                safe.argumentNotNull(options.appManager, "options.appManager");

                this._map = options.map;
                this._olMap = options.map.olMap;
                this._popupContainers = [];
                this._popupOverlays = [];
                this._handlers = [];

                this.appManager = options.appManager;
                this.mode = options.mode || "single";
            },
            /** 
             */
            createPopupContent: function (groupWidgets) {
                var contentWidget = new ContentPane();
                groupWidgets.forEach(function (groupWidget) {
                    if (groupWidget && !groupWidget.isEmpty()) {
                        contentWidget.addChild(groupWidget);
                    }
                });
                return contentWidget;
            },

            /**
             * Возвращает обещание на получение объекта с результатом идентификации
             * по всем видимым режимам и информационным слоям @ options {Object} @ pixel
             * {Object} - информация о точке идентификации @ coordinate {Array} -
             * координаты точки иденификации
             */
            getGroupsFromVisibleModules: function (options) {
                var promises = [];
                var modules = this.appManager.getVisibleModules();
                modules.forEach(function (module) {
                    promises.push.apply(promises, module
                        .getIdentifyResult(options));
                });

                return promiseAll(promises).then(
                    function (results) {
                        console.log("promise all groups = ", results);
                        return results;
                    });
            },

            identifyPosition: function (position) {
                var me = this, i;
                var popupContainer = null,
                    popupOverlay = null;
                if (me.mode == "multiple") {
                    // TODO: создать popupContainer и popupOverlay
                    popupContainer = new PopupContainer({
                        map: me._olMap
                    });
                    on(popupContainer, "close", function () {
                        var index = me._popupContainers.indexOf(me);
                        me._popupContainers.splice(index, 1);

                    });
                    me._popupContainers.push(popupContainer);

                    popupOverlay = new ol.Overlay({
                        element: popupContainer.domNode,
                        autoPan: true,
                        autoPanAnimation: {
                            duration: 250
                        }
                    });
                    me._popupOverlays.push(popupOverlay);
                    me._olMap.addOverlay(popupOverlay);

                } else {
                    if (me._popupContainers.length > 0) {
                        // Берем первый
                        popupContainer = me._popupContainers[0];
                        // Все остальные удалить
                        if (me._popupContainers.length > 1) {
                            for (i = 1; i < me._popupContainers.length; i++) {
                                me._popupContainers[i].destroyRecursive();
                            }
                            me._popupContainers.splice(
                                1,
                                me._popupContainers.length - 1);
                        }
                    } else {
                        // Создаем новый
                        popupContainer = new PopupContainer({
                            map: me._olMap
                        });
                        on(popupContainer, "close", function () {
                            var index = me._popupContainers.indexOf(me);
                            me._popupContainers.splice(index, 1);

                        });
                        me._popupContainers.push(popupContainer);
                    }
                    if (me._popupOverlays.length > 0) {
                        // Берем первый и помещаем в него popup
                        popupOverlay = me._popupOverlays[0];
                        popupOverlay.setElement(popupContainer.domNode);
                        // Все остальные удалить
                        if (me._popupOverlays.length > 1) {
                            for (i = 1; i < me._popupOverlays.length; i++) {
                                me._olMap.removeOverlay(me._popupOverlays[i]);
                            }
                            me._popupOverlays.splice(
                                1,
                                me._popupOverlays.length - 1)
                        }
                    } else {
                        // Создаем новый и помещаем в него popup
                        popupOverlay = new ol.Overlay({
                            element: popupContainer.domNode,
                            autoPan: true,
                            autoPanAnimation: {
                                duration: 250
                            }
                        });
                        me._popupOverlays.push(popupOverlay);
                        me._olMap.addOverlay(popupOverlay);
                    }
                }

                popupContainer.destroyDescendants();

                popupOverlay.setPosition(position.coordinate);

                popupContainer.showOverlay();

                when(me.getGroupsFromVisibleModules(position), function (data) {
                    var contentWidget = me.createPopupContent(data);
                    popupContainer.show(contentWidget, "only");
                    popupContainer.hideOverlay();
                });
            },
            /**
             * Скрыть все popups
             */
            hideAllPopups: function () {
                var me = this, i;
                for (i = 0; i < this._popupContainers.length; i++) {
                    this._popupContainers[i].destroyRecursive();
                }
                this._popupContainers.splice(0, this._popupContainers.length);

                for (i = 0; i < this._popupOverlays.length; i++) {
                    this._olMap.removeOverlay(this._popupOverlays[i]);
                }
                this._popupOverlays.splice(0, this._popupOverlays.length)
            },

            onActivating: function () {
                var me = this;
                // Обработчик для события "singleclick" по карте
                var handler = listen(this._olMap, 'singleclick', function (evt) {
                    if (evt.originalEvent.ctrlKey) {
                        me.mode = "multiple";
                    } else {
                        me.mode = "single";
                    }
                    me.identifyPosition({
                        pixel: evt.pixel,
                        coordinate: evt.coordinate
                    });
                });
                this._handlers.push(handler);
            },

            onDeactivating: function () {
                var me = this;
                me._handlers.forEach(function (handler) {
                    if (handler.remove)
                        handler.remove();

                });
                this.hideAllPopups();
            },
        })
    });