define([ "dojo/_base/declare", "ol", "dojo/Evented" ], function(declare, ol,
    Evented) {

    var peekFirstFeature = function(map, coordinate, pixel) {
        return map.forEachFeatureAtPixel(function(ft, layer) {
            return ft;
        });
    };

    var cls = declare([ ol.interaction.Pointer ], {
        "-chains-" : {
            constructor : "manual"
        },

        _peek : null,

        _feature : null,

        _coordinate : null,

        cursor : "pointer",

        _oldCursor : undefined,

        /**
         * Создает новый объект
         * 
         * @param {Object}
         *            opts опции
         * @param {Function}
         *            opts.peek Функция выбора фичи для перетаскивания
         *            function(map,coordinate,pixel), возвращает фичу
         * @param {String}
         *            opts.cursor css курсор который будет использован при
         *            наведении и перетаскивании фичи
         * 
         */
        constructor : function(opts) {
            
            ol.interaction.Pointer.apply(this, [{
                handleDownEvent : this.handleDownEvent,
                handleDragEvent : this.handleDragEvent,
                handleMoveEvent : this.handleMoveEvent,
                handleUpEvent : this.handleUpEvent
            }]);
            Evented.apply(this);

            if (opts) {
                if (opts.peek) {
                    this._peek = opts.peek;
                } else {
                    this._peek = peekFirstFeature;
                }
                if ("cursor" in opts)
                    this.cursor = opts.cursor;
            }
        },

        handleDownEvent : function(evt) {
            var c = evt.coordinate;

            var ft = this._peek(evt.map, c, evt.pixel);

            if (ft) {
                this._feature = ft;
                this._coordinate = c;
                this._emit("dragbegin", { feature : ft });
                return true;
            }

            return false;
        },

        handleDragEvent : function(evt) {
            var c1 = this._coordinate, c2 = evt.coordinate;

            var dx = c2[0] - c1[0];
            var dy = c2[1] - c1[1];

            this._emit("dragging", { feature : this._feature, fromCoord : c1, toCoord : c2 });

            this._feature.getGeometry().translate(dx, dy);

            this._coordinate = c2;
        },

        handleUpEvent : function(evt) {
            if (this._feature)
                this._emit("dragend", { feature : this._feature });

            this._feature = null;
            this._coordinate = null;
            return false;
        },

        handleMoveEvent : function(evt) {
            if (this.cursor) {
                var ft = this._feature || this._peek(evt.map, evt.coordinate , evt.pixel);

                var element = evt.map.getTargetElement();
                if (ft) {
                    if (element.style.cursor != this.cursor) {
                        this._oldCursor = element.style.cursor;
                        element.style.cursor = this.cursor;
                    }
                } else if (this._oldCursor !== undefined) {
                    element.style.cursor = this._oldCursor;
                    this._oldCursor = undefined;
                }
            }
        },
        
        _emit : function(name, data) {
            var evt = new ol.source.VectorEvent(name,this);
            
            for(var p in data)
                evt[p] = data[p];
            this.dispatchEvent(evt);
        }
    });
    
    return cls;
});