define([
    "dojo/_base/declare",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dijit/_WidgetsInTemplateMixin",
    "dojo/text!./resources/LayerRadioButtonTemplate.html",
    "dijit/form/RadioButton" ], function(declare, _WidgetBase, _TemplatedMixin,
    _WidgetsInTemplateMixin, templateString) {
    return declare([ _WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin ], {
        templateString : templateString,

        labelNode : null,
        radioButton : null,

        label : "",
        _setLabelAttr : {
            node : "labelNode",
            type : "innerHTML"
        },

        name : "layers",

        _layer : null,

        constructor : function(options) {
            options = options || {};

            if (!options.layer)
                throw new Error("The layer is required");

            this._layer = options.layer;
            this.label = options.layer.get("label") || "unnamed";
        },

        postCreate : function() {
            var me = this;
            me.inherited(arguments);

            me.radioButton.set('name', me.name);
            me.radioButton.set('value', me._layer.getVisible());
            this.radioButton.on("change", function(value) {
                me._changed(value);
            });
        },

        _changed : function(visible) {
            this._layer.setVisible(visible);
        }
    });
});