﻿define(
    [
        "implab/safe",
        'dijit/_WidgetBase',
        'dijit/_TemplatedMixin',
        "dijit/_WidgetsInTemplateMixin",
        "dijit/layout/_LayoutWidget",
        "dijit/layout/ContentPane",
        "dojo/_base/declare",
        "dojo/dom-construct",
        "dojo/on",
        "ol3/IdentifyItem" ],
    function(
        safe,
        _WidgetBase,
        _TemplatedMixin,
        _WidgetsInTemplateMixin,
        _LayoutWidget,
        ContentPane,
        declare,
        domConstruct,
        on,
        IdentifyItem) {

        return declare(
            [ _LayoutWidget, _TemplatedMixin, _WidgetsInTemplateMixin ],
            {

                /**
                 */
                _empty : true,
                /**
                 */
                layerName : null,
                /**
                 * Шаблон всего widget
                 */
                templateString : "<div class='identify-item-group'><div data-dojo-attach-point='identifyItemGroupTitle' class='identify-item-group-title'></div><div class='identify-item-group-content-container' data-dojo-attach-point='containerNode'></div></div>",

                itemTemplate : "",

                title : null,

                /**
                 * Метод из widget.lifecycle
                 */
                postCreate : function() {
                    var me = this;
                    if (typeof this.title == "string") {
                        this.identifyItemGroupTitle.innerHTML = me.title;
                    } else if (me.title && me.title.placeAt) {
                        me.title.placeAt(me.identifyItemGroupTitle, "only");
                    } else {
                        domConstruct.place(
                            me.title,
                            me.identifyItemGroupTitle,
                            "only");
                    }
                    on(this.domNode, "click", function() {
                        if ("function" == typeof me.callback) {
                            me.callback();
                        }
                    });
                },

                addItem : function(options) {
                    safe.argumentNotNull(options, "options");
                    safe.argumentNotNull(options.model, "options.model");

                    if (options.model) {

                        var item = new IdentifyItem({
                            title : options.title || this.itemTemplate,
                            model : options.model,
                            callback : options.callback
                        });
                        this.addChild(item);
                        this._empty = false;
                    } else {
                        console
                            .error("Не задано необходимое свойство layerFeature");
                    }
                },

                isEmpty : function() {
                    return this._empty;
                }
            });
    });