﻿define([
    "dijit/registry",
    "dojo/_base/declare",
    "dijit/_WidgetBase",
    "dojo/dom-construct",
    "./PopupContainer",
    "dojo/_base/array",
    "ol",
    "ol3/listen",
    "dojo/Deferred",
    "implab/safe"
], function (registry, declare, _WidgetBase, dom, PopupContainer, array, ol, listen, Deferred, safe) {

    return declare([_WidgetBase], {
        popupOverlays: null,
        olMap: null,

        _pending: null,

        constructor: function () {
            this._pending = {};
        },

        buildRendering: function () {
            this.domNode = dom.create("div");
        },

        postCreate: function () {
            this.inherited(arguments);
            this.popupOverlays = {};
            this.olMap = new ol.Map({
                target: this.domNode,
                layers: this.layers,
                view: this.view,
                controls: this.controls || [],
            });
        },

        getProjection : function() {
            return this.view.getProjection();
        },

        addInteraction: function (value) {
            this.olMap.addInteraction(value);
        },

        addLayer: function (layer) {
            if (layer) {
                if (layer.get("layerType") == "base")
                    this.olMap.getLayers().insertAt(0, layer);
                else
                    this.olMap.addLayer(layer);
            }
        },

        removeLayer: function(layer) {
            this.olMap.removeLayer(layer);
        },

        startup: function () {
            this.inherited(arguments);

            this.olMap.updateSize();
        },

        showPopup: function (contentWidget, position, opts) {
            // Скрыть popups указанной в opts.role роли, если (opts.hint ==
            // "replace")
            // Если не задан opts или opta.hint скрывать все popup

            var me = this;

            if ((!opts) || (!opts.hint)) {
                this.closeAllPopups();
            } else if ((opts.hint) && (opts.hint == "replace")) {
                if (opts.role) {
                    this.closePopupsByRole(opts.role);
                } else {
                    this.closeAllPopups();
                }
            }
            var overlay = new ol.Overlay({});

            if (opts && (opts.role)) {
                if (this.popupOverlays[opts.role]) {
                    this.popupOverlays[opts.role].push(overlay);
                } else {
                    this.popupOverlays[opts.role] = [overlay];
                }
            }

            // Отображение popUp start
            this.olMap.addOverlay(overlay);
            var popup = new PopupContainer({
                overlay: overlay,
                map: this.olMap,
                onClose: function () {
                    // registry.byNode(overlay.getElement()).destroyRecursive();
                    array.forEach(me.popupOverlays[opts.role], function (o) {
                        if (o === overlay) {
                            var index = me.popupOverlays[opts.role].indexOf(o);
                            if (index > -1) {
                                me.popupOverlays[opts.role].splice(index, 1);
                            }
                        }
                    });
                }
            });
            overlay.setElement(popup.domNode);
            popup.show(contentWidget);
            overlay.setPosition(position);
            popup.hideOverlay();
            // end
            return popup;
        },

        closeAllPopups: function () {
            var overlays = this.olMap.getOverlays();
            overlays.forEach(function (elenemt, index) {
                registry.byNode(elenemt.getElement()).destroyRecursive();
            }, this);
            this.popupOverlays = {};
        },

        closePopupsByRole: function (role) {
            if (this.popupOverlays[role]) {
                array.forEach(this.popupOverlays[role], function (overlay) {
                    registry.byNode(overlay.getElement()).destroyRecursive();
                });
                this.popupOverlays[role] = [];
            }
        },

        /**
         * Подписывается на событие карты
         * 
         * @param {String}
         *            name Имя события
         * @param {function(evt)}
         *            filter Фильтр того, что событие нужное
         * 
         * @returns {ol.ObjectEvent | ol.MapBroeserEvent | ol.MapEvent} Событие
         *          на которое подписались.
         */
        awaitMapEvent: function (name, filter) {
            safe.argumentNotEmptyString(name, "name");
            var map = this.olMap,
                handle, d, me = this;

            if (me._pending[name])
                throw new Error("An event is already pending: " + name);

            me._pending[name] = d = new Deferred(function () {
                handle.remove();
            });

            handle = listen.once(map, name, function (evt) {
                if (!filter || filter(evt))
                    d.resolve(evt);
            });

            return d.then(function (evt) {
                delete me._pending[name];
                return evt;
            }, function (err) {
                delete me._pending[name];
                throw err;
            });
        },

        cancelPendingEvents: function () {
            for (var name in this._pending)
                this._pending[name].cancel();
        }
    });
});