﻿define([
    "dojo/_base/declare",
    "implab/safe",
    "ol",
    "./listen",
    "./_ToolBase",
    "dojo/dom-construct",
    "dojo/dom-class"
], function (declare, safe, ol, listen, _ToolBase, dconstruct, dclass) {
    return declare([_ToolBase], {
        _draw: null,

        drawStyle: new ol.style.Style({
            fill: new ol.style.Fill({
                color: 'rgba(255, 255, 255, 0.2)'
            }),
            stroke: new ol.style.Stroke({
                color: 'rgba(230, 126, 34, 0.7)',
                lineDash: [10, 10],
                width: 2
            }),
            image: new ol.style.Circle({
                radius: 5,
                stroke: new ol.style.Stroke({
                    color: 'rgba(0, 0, 0, 0.7)'
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(255, 255, 255, 0.2)'
                })
            })
        }),

        vectorStyle: new ol.style.Style({
            fill: new ol.style.Fill({
                color: 'rgba(255, 255, 255, 0.2)'
            }),
            stroke: new ol.style.Stroke({
                color: '#ffcc33',
                width: 2
            }),
            image: new ol.style.Circle({
                radius: 7,
                fill: new ol.style.Fill({
                    color: '#ffcc33'
                })
            })
        }),

        _map: null,

        _olMap: null,

        _measureTooltipElement: null,
        /**
         * Overlay to show the measurement.
         * 
         * @type {ol.Overlay}
         */
        _measureTooltip: null,

        _pointermoveKey: null,

        _sketch: null,

        _overlays: null,

        _vector: null,

        wgs84Sphere: new ol.Sphere(6378137),

        constructor: function (options) {
            safe.argumentNotNull(options, "options");
            safe.argumentNotNull(options.map, "map");

            this._map = options.map;
            this._olMap = options.map.olMap;
            this._overlays = [];
        },

        init: function () {
            if (this._draw)
                return;

            var source = new ol.source.Vector();

            this._vector = new ol.layer.Vector({
                source: source,
                style: this.vectorStyle
            });
            this._map.addLayer(this._vector);

            this._draw = this._createDraw(source);
            this._draw.on('drawstart', this._onDrawStart, this);
            this._draw.on('drawend', this._onDrawEnd, this);

        },

        onActivating: function () {
            this.init();

            this._pointermoveKey = listen(this._olMap, 'pointermove', safe.delegate(this, "_onPointerMove"));
            this._olMap.addInteraction(this._draw);

            return this.inherited(arguments);
        },

        onDeactivating: function () {
            // отключаем рисование и получение сообщений
            if (this._pointermoveKey)
                this._pointermoveKey.remove();
            this._olMap.removeInteraction(this._draw);

            // если был активен инструмент
            if (this._sketch) {
                // убиваем подсказку и сбрасываем текущее рисование
                this._sketch = null;
                this._measureTooltipElement = null;
                this._olMap.removeOverlay(this._measureTooltip);
            }

            return this.inherited(arguments);
        },

        clear: function () {
            var me = this;
            me.log("clear");
            if (me._vector) {
                me._vector.getSource().clear();
                me._overlays.forEach(function (x) {
                    me._olMap.removeOverlay(x);
                });
            }
        },

        _createMeasureTooltip: function () {
            this._measureTooltipElement = dconstruct.create("div", {
                "class": 'tooltip poisk-measure-tooltip'
            });
            this._measureTooltip = new ol.Overlay({
                element: this._measureTooltipElement,
                offset: [0, -15],
                positioning: 'bottom-center'
            });
            this._olMap.addOverlay(this._measureTooltip);

        },

        _onDrawStart: function (evt) {
            this._sketch = evt.feature;
            this._createMeasureTooltip();
        },

        _onDrawEnd: function (evt) {

            this._measureTooltip.setOffset([0, -7]);

            dclass.remove(this._measureTooltipElement, "tooltip");
            dclass.add(this._measureTooltipElement, "tooltip-static");

            this._overlays.push(this._measureTooltip);

            this._sketch = null;
            this._measureTooltip = null;
            this._measureTooltipElement = null;
        },

        _onPointerMove: function (evt) {
            if (this._sketch && !evt.dragging) {
                this._measureTooltip.setPosition(evt.coordinate);
                this._measureTooltipElement.innerHTML = this._formatTooltip(
                    this._sketch,
                    this._olMap.getView().getProjection());
            }
        },

        _formatTooltip: function (sketch, proj) {

        }
    });

});