define([
    "dojo/_base/declare",
    "implab/safe",
    "./MeasureToolBase",
    "implab/text/format",
    "dojo/i18n!./format/nls/units",
    "ol" ],

function(declare, safe, MeasureToolBase, format, units, ol) {
    return declare([ MeasureToolBase ], {

        isGeodesic : true,
        
        units : 'metric',
        
        constructor : function(opts) {
            if (opts)
                safe.mixin(this,opts,["isGeodesic", "units"]);
        },

        _createDraw : function(source) {
            return new ol.interaction.Draw({
                source : source,
                type : "Polygon",
                style : this.drawStyle
            });
        },

        _formatTooltip : function(sketch, proj) {
            var area;
            if (this.isGeodesic) {
                                var geom = sketch.getGeometry().clone().transform(proj, 'EPSG:4326');
                var coordinates = geom.getLinearRing(0).getCoordinates();
                area = Math.abs(this.wgs84Sphere.geodesicArea(coordinates));
            } else {
                area = sketch.getGeometry().getArea();
            }
            
            var mpu, unitName;
            switch (this.units) {
                case "nautical":
                    mpu = 1852*1852;
                    unitName = units.nmiles2;
                    break;
                default:
                    mpu = 1852*1852;
                    unitName = units.kilometers2;
            }

            if (area > mpu/10) {
                return format(
                    "{0:#0.##} {1}",
                    area / mpu,
                    unitName);
            } else {
                return format("{0:#0.##} {1}", area, units.meters2);
            }
        }

    });
});