define(
    [ "dojo/i18n!./nls/coords", "implab/text/format", "implab/safe" ],

    function(nls, format, safe) {

        var formatDMS = function(coord) {
            return formatSD(coord, nls.dmsPattern);
        };

        var formatDM = function(coord) {
            return formatSD(coord, nls.dmPattern);
        };

        var formatD = function(coord) {
            return formatSD(coord, nls.dPattern);
        };

        /**
         * pattern:
         * 
         * {0} - signed floating point number - latitude
         * 
         * {1} - positive floating point number - minutes part of latitude
         * 
         * {2} - positive floating point number - seconds part of latitude
         * 
         * {3} - localized hemisphere sign: north or south
         * 
         * {4} - signed floating point number - longitude
         * 
         * {5} - positive floating point number - minutes part of longitude
         * 
         * {6} - positive floating point number - seconds part of longitude
         * 
         * {7} - localized hemisphere sign: east or west
         */
        var formatSD = function(coord, pattern) {
            safe.argumentNotNull(coord, "coord");
            if (!pattern)
                pattern = nls.sdPattern;
            var x = (coord[0] % 360 + 540) % 360 - 180, y = (coord[1] % 180 + 270) % 180 - 90;

            return format(pattern, y, Math.abs((y * 60) % 60), Math
                .abs((y * 3600) % 60), y >= 0 ? nls.north : nls.south, x, Math
                .abs((x * 60) % 60), Math.abs((x * 3600) % 60), x >= 0
                ? nls.east
                : nls.west);
        };

        var cls = function(fmt) {
            switch (fmt) {
            case "DMS":
                return formatDMS;
            case "DM":
                return formatDM;
            case "D":
                return formatD;
            case "SD":
                return formatSD;
            default:
                if (!fmt)
                    return formatSD;
                else
                    return function(coord) {
                        return formatSD(coord, fmt);
                    }
            }
        };

        return cls;
    });