﻿define([       
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dijit/_WidgetsInTemplateMixin",
    "dijit/_Container",
    "dojo/_base/declare",
    "dojo/Evented",
    "dojo/dom-class",
    "dojo/on",
    "dojo/text!./resources/PopupContainerTemplate.html",
    "ol"
],
    function (_WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin, _Container, declare, Evented, domClass, on, templateString, ol) {
        return declare([_WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin, _Container/*, Evented*/], {

            templateString: templateString,
            
            overlay: null,
            
            map : null,

            constructor: function (options) {
                options = options || {};                
            },

            postCreate: function () {
                var me = this;                
                this.inherited(arguments);
                on(this.popupCloser, "click", function () {
                    me.destroyRecursive();
                    me.onClose();
                });
            },
                        
            show: function (widget, opts) {
                opts = opts || "only";
                if (widget) {
                    widget.placeAt(this.popupContent, opts);
                }                
            },

            hideOverlay: function () {
                domClass.add(this.popupOverlay, "hidden")
            },

            showOverlay: function () {
                domClass.remove(this.popupOverlay, "hidden")
            },

            destroy : function() {
                this.map.removeOverlay(this.overlay);                
                this.inherited(arguments);
            },

            onClose: function () {                
                this.emit("close");
            }

        });
    });