define([
    "dojo/_base/declare",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dijit/_WidgetsInTemplateMixin",
    "dojo/text!./resources/LayerCheckBoxTemplate.html",
    "dijit/form/CheckBox" ], function(declare, _WidgetBase, _TemplatedMixin,
    _WidgetsInTemplateMixin, templateString) {
    return declare([ _WidgetBase, _TemplatedMixin, _WidgetsInTemplateMixin ], {
        templateString : templateString,
        labelNode : null,
        checkBox : null,

        label : "",
        _setLabelAttr : {
            node : "labelNode",
            type : "innerHTML"
        },

        name : "layer",

        _layer : null,

        constructor : function(options) {
            options = options || {};

            if (!options.layer)
                throw new Error("The layer is required");

            this._layer = options.layer;
            this.label = options.layer.get("label") || "unnamed";
        },

        postCreate : function() {
            var me = this;
            me.inherited(arguments);

            me.checkBox.set('name', me.name);
            me.checkBox.set('value', me._layer.getVisible());
            this.checkBox.on("change", function(value) {
                me._changed(value);
            });
        },

        _changed : function(visible) {
            this._layer.setVisible(visible);
        }
    });
});