define(["dojo/_base/declare", "dojo/_base/lang", "implab/safe", "dojo/dom-class", "dojo/dom-construct", "dijit/_TemplatedMixin", "dijit/_WidgetBase"],
    function (declare, lang, safe, domClass, domConstruct, _TemplatedMixin, _WidgetBase) {
    return declare([_WidgetBase, _TemplatedMixin], {
        map : null,
        control : null,
        elementName : "div",
        
        constructor: function () {
            lang.mixin(this, arguments[0]);
            safe.argumentNotNull(this.map, "map");
            safe.argumentNotNull(this.control, "control");
        },
        
        buildRendering : function() {
            this.domNode = domConstruct.create(this.elementName);
            domClass.add(this.domNode, this.baseClass);
            this.control.setTarget(this.domNode);
            this.control.setMap(this.map.olMap || this.map);
        }
    });
});