define([
    "dojo/_base/declare",
    "dojo/when",
    "implab/safe",
    "implab/guard",
    "implab/components/_ActivatableMixin",
    "implab/log/_LogMixin",
    "dojo/Evented",
    "./ToolType" ],

function(declare, when, safe, guard, _ActivatableMixin, _LogMixin, Evented, ToolType) {
    return declare([ _ActivatableMixin,  Evented ], {
        toolType : ToolType.Activatable,
        
        module : null,

        constructor : function(opts) {
            if (opts) {
                if (opts.controller)
                    this.setController(opts.controller);
            }
        },
        
        onActivating : function() {
            var me = this, inherited = this.getInherited(arguments);
            if (me.module && !me.module.isActive())
                return me.module.activate().then(function(active) {
                    return active ? inherited.apply(me) : false;
                });
            else
                return inherited.apply(me);
        },

        onActivated : function() {
            this.emit("active", true);
        },

        onDeactivated : function() {
            this.emit("active", false);
        },
        
        destroy : function() {
            
        }
    });
});