﻿define([
    "implab/guard",
    "implab/text/template-compile",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/Deferred",
    "ol"],
    function (guard, compile, declare, lang, Deferred, ol) {
        return declare([ol.layer.Vector], {

            map: null,

            _olMap: null,

            name: null,

            displayName: null,

            identifyResultTemplate: null,

            identifyCompiledTemplate:null,

            searchResultTemplate: null,

            searchCompiledTemplate: null,

            constructor: function () {
                lang.mixin(this, arguments[0]);
                this._olMap = this.map.olMap;
                var identifyCompiledTemplate = null, searchCompiledTemplate = null;
                if (this.identifyResultTemplate) {
                    this.identifyCompiledTemplate = compile(this.identifyResultTemplate);
                }
                if (this.searchResultTemplate) {
                    this.searchCompiledTemplate = compile(this.searchResultTemplate);
                }
            },

            /** Возвращает массив строк, каждая строка - результат поиска  приведенный к шаблонному виду
                @options {Object}
                    @str {String} поисковая строка
                    @bbox {Object} bound box, в рамках которого осуществлять поиск
            */
            getSearchResult: function (options) {
                return null;
            },

            _getIdentifyResult: function (options) {
                var me = this;
                var features = [];
                //TODO: добавить фильтр по layer равный ему самому
                this._olMap.forEachFeatureAtPixel(options.pixel, function (feature, layer) {
                    features.push({ feature: feature, layer: layer });
                }, null, function (layer) {
                    return layer == me;
                });
                console.log(features);
                return features;
            },
            /** Возвращает массив строк, каждая строка - результат идентификации приведенный к шаблонному виду
                @options {Object}
                    @coordinates {Array} массив описывающий координаты точки идентификации                    
            */
            getIdentifyResult: function (coordinates) {
                return guard(this, "_getIdentifyResult", [coordinates]);
            }
        });
    })