define(["dojo/_base/declare", "implab/safe", "implab/guard", "ol3/_ToolBase", "ol3/ToolType"],

    function (declare, safe, guard, _ToolBase, ToolType) {
        return declare([_ToolBase], {
            _pending: null,

            _lastResult: null,

            toolType: ToolType.Oneshot,

            invoke: function () {
            },

            onActivating: function () {
                var me = this;

                // start the operation
                me._lastResult = me._pending = guard(me, "invoke");

                return this.inherited(arguments);
            },

            onActivated: function () {
                var me = this;

                // fire the activate event
                this.inherited(arguments);

                me._pending.then(function () {
                    if (me._pending) {
                        me.log("Operation finished, deactivating.");
                        me._pending = null;
                        me.deactivate();
                    }
                }, function (ex) {
                    if (me._pending) {
                        me.error("Operation failed, deactivating: {0}", ex);
                        me._pending = null;
                        me.deactivate();
                    }
                });
            },

            onDeactivated: function () {
                var d = this._pending;
                if (d) {
                    this.log("Cancelling pending operation");
                    this._pending = null;
                    d.cancel();
                }

                return this.inherited(arguments);
            },

            run: function () {
                var me = this;

                return me.activate().then(function () {
                    return me._lastResult;
                });
            }
        });
    });