﻿define([
    'dijit/_WidgetBase',
    'dijit/_TemplatedMixin',
    "dijit/Tooltip",
    "dojo/_base/declare",
    "dojo/date/locale",
    "dojo/dom-construct",
    "dojo/on" ], function(_WidgetBase, _TemplatedMixin, Tooltip, declare,
    dateLocale, domConstruct, on) {
    var empty = {};
    return declare([ _WidgetBase, _TemplatedMixin ], {

        callback : null,

        dateLocale : dateLocale,

        baseClass : 'identify-item',

        feature : null,

        model : empty,

        title : null,

        templateString : "<div class='identify-item'></div>",

        constructor : function(options) {
            option = options || {};
            if (options.title)
                this.title = options.title;
            if (options.model)
                this.model = options.model;
            if (options.callback)
                this.callback = options.callback;

        },

        /**
         * Метод из widget.lifecycle
         */
        postCreate : function() {
            var me = this;

            var content = me.title instanceof Function ? me.title(me)
                : me.title;

            if (typeof content == "string") {
                me.domNode.innerHTML = content;
            } else if (content && content.placeAt) {
                content.placeAt(me.domNode, "only");
            } else {
                domConstruct.place(content, me.domNode, "only");
            }

            on(me.domNode, "click", function() {
                if (typeof me.callback == "function") {
                    me.callback(me.model);
                }
            });
        },
    });
});