define([ "ol" ], function(ol) {

    function buildFilter(filter) {
        if (filter instanceof Function)
            return filter;
        if (filter) {
            var match = function(str) {
                return {
                    test : function(x) {
                        if (x === null || x === undefined)
                            return false;
                        return x.toString().startsWith(str);
                    }
                };
            };

            for ( var p in filter) {
                if (typeof (filter[p]) == "string" && filter[p].endsWith("*"))
                    filter[p] = match(filter[p].substr(0, filter[p].length));
            }
            return function(ft) {
                for ( var p in filter) {
                    if (filter[p] && filter[p].test ? !filter[p]
                        .test(ft.get(p)) : ft.get(p) != filter[p])
                        return false;
                }
                return true;
            };
        }
        throw new Error("Unsupported filter");
    }

    /**
     * @constructor
     * @example
     * 
     * <pre>
     * var store = new VectorStore({
     *     source : vectorSource
     * });
     * 
     * var req = new VectorStoreQuery({
     *     city : &quot;Moscow&quot;
     * }, [ 30, 50, 40, 60 ]);
     * 
     * store.query(req).then(showResults);
     * </pre>
     */
    return function(filter, extent) {
        var match = filter && buildFilter(filter);

        var query = function(ft) {
            if (extent) {
                var g = gt.getGeometry();
                if (!g || !ol.extent.intersects(extent, g.getExtent()))
                    return false;
            }

            return !match || match(ft);
        };

        query.extent = extent;
        query.predicate = match;

        return query;
    };
});