define([ "dojo/Deferred" ], function(Deferred) {
    var toPromise = function(d) {
        if (d && d.then)
            return d;
        var d2 = new Deferred();
        d2.resolve(d);
        return d2;
    };

    /**
     * функция для асинхронного выполнения метода
     * 
     * @async
     * @param{Object} o Объект, который будет использован в качестве
     *                <code>this</code>, если не указан, будет
     *                <code>null</code>
     * @param{Function|String} m Функция или имя метода, обязательный параметр.
     *                         Если указано имя, тогда параметр <code>o</code>
     *                         также должен быть задан
     * @param{Array} args Параметры для вызова метода, не обязательно.
     * @returns{dojo/promise}
     */
    return function(o, m, args) {
        if (arguments.length == 1) {
            m = o;
            o = null;
        } else if (arguments.length == 2 && o instanceof Function &&
            m instanceof Array) {
            args = m;
            m = o;
            o = null;
        }

        try {
            if (!(m instanceof Function)) {
                if (o)
                    m = o[m];
                else if (arguments.length == 1)
                    return toPromise(m);
                else
                    throw new Error("The target object must be specified");
            }

            if (!m)
                throw new Error("Method not found");

            return toPromise(m.apply(o, args));
        } catch (err) {
            var d = new Deferred();
            d.reject(err);
            return d;
        }
    };
});