﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.JSON {
    /// <summary>
    /// Тип токенов, возвращаемых <see cref="JSONScanner"/>.
    /// </summary>
    public enum JsonTokenType : int {
        None = 0,
        /// <summary>
        /// Начало объекта
        /// </summary>
        BeginObject,
        /// <summary>
        /// Конец объекта
        /// </summary>
        EndObject,
        /// <summary>
        /// Начало массива
        /// </summary>
        BeginArray,
        /// <summary>
        /// Конец массива
        /// </summary>
        EndArray,
        /// <summary>
        /// Строка
        /// </summary>
        String,
        /// <summary>
        /// Число
        /// </summary>
        Number,
        /// <summary>
        /// Литерал
        /// </summary>
        Literal,
        /// <summary>
        /// Разделитель имени <c>:</c>
        /// </summary>
        NameSeparator,
        /// <summary>
        /// Разделитель имени <c>,</c>
        /// </summary>
        ValueSeparator
    }
}
