﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Implab
{
    public static class Safe
    {
        public static void ArgumentMatch(string param, string name, Regex rx) {
            if (rx == null)
                throw new ArgumentNullException("rx");
            if (!rx.IsMatch(param))
                throw new ArgumentException(String.Format("A prameter value must match {0}", rx), name);
        }

        public static void ArgumentNotEmpty(string param, string name) {
            if (String.IsNullOrEmpty(param))
                throw new ArgumentException("A parameter can't be empty", name);
        }

        public static void ArgumentNotNull(object param, string name) {
            if (param == null)
                throw new ArgumentNullException(name);
        }

        public static void Dispose<T>(T obj) where T : class
        {
            var disp = obj as IDisposable;
            if (disp != null)
                disp.Dispose();
        }
    }
}
