﻿using System;
using Implab.Parallels;
using System.Threading;

namespace Implab {
    public class ComponentContainer : IComponentContainer, IDisposable {
        static readonly ComponentContainer _appContainer;

        static ComponentContainer() {
            _appContainer = new ComponentContainer();
            AppDomain.CurrentDomain.ProcessExit += HandleProcessExit;
        }

        public static ComponentContainer Global {
            get {
                return _appContainer;
            }
        }

        bool m_disposed;
        readonly AsyncQueue<IDisposable> m_components = new AsyncQueue<IDisposable>();

        public void Add(IDisposable item) {
            Safe.ArgumentNotNull(item, "item");
            Thread.MemoryBarrier();
            if (m_disposed) {
                item.Dispose();
            } else {
                m_components.Enqueue(item);
                if (m_disposed && m_components.TryDequeue(out item))
                    item.Dispose();
            }
        }

        public void Dispose() {
            m_disposed = true;
            IDisposable item;
            while (m_components.TryDequeue(out item))
                item.Dispose();
        }

        static void HandleProcessExit (object sender, EventArgs e)
        {
            _appContainer.Dispose();
        }
    }
}

