﻿using System;

namespace Implab {
    public interface IPromise<out T> : IPromise {

        new T Join();

        new T Join(int timeout);

        IPromise<T> On(Action<T> success, Action<Exception> error, Action cancel);
        
        IPromise<T> On(Action<T> success, Action<Exception> error);

        IPromise<T> On(Action<T> success);

        new IPromise<T> On(Action handler, PromiseEventType events);

        IPromise<T2> Then<T2>(Func<T, T2> mapper, Func<Exception,T2> error, Func<T2> cancel);

        IPromise<T2> Then<T2>(Func<T, T2> mapper, Func<Exception,T2> error);

        IPromise<T2> Then<T2>(Func<T, T2> mapper);

        IPromise<T2> Chain<T2>(Func<T, IPromise<T2>> chained, Func<Exception,IPromise<T2>> error, Func<IPromise<T2>> cancel);

        IPromise<T2> Chain<T2>(Func<T, IPromise<T2>> chained, Func<Exception,IPromise<T2>> error);

        IPromise<T2> Chain<T2>(Func<T, IPromise<T2>> chained);

        IPromise<T2> Error<T2>(Func<Exception,T2> error);

        IPromise<T2> Cancelled<T2>(Func<T2> handler);
    }
}
