﻿using System;

namespace Implab.Automaton {
    public interface IDFADefinitionBuilder<TTag> {
        /// <summary>
        /// Marks the state as final and assings tags.
        /// </summary>
        /// <param name="state">State.</param>
        /// <param name="tags">Tags.</param>
        void MarkFinalState(int state, params TTag[] tags);

        /// <summary>
        /// Defines the transition from <paramref name="s1"/> to
        /// <paramref name="s2"/> with input <paramref name="symbol"/>.
        /// </summary>
        /// <param name="s1">S1.</param>
        /// <param name="s2">S2.</param>
        /// <param name="symbol">Symbol.</param>
        void DefineTransition(int s1, int s2, int symbol);

    }
}

