using System;
using System.Threading.Tasks;

namespace Implab.Components {
    /// <summary>
    /// An interface for asynchronous components.
    /// </summary>
    /// <remarks>
    /// <para>
    /// Асинхронные компоненты не предназначены для одновременного использования несколькими клиентами,
    /// однако существуют внутренние процессы, изменяющее состояние компонент без участия клиента.
    /// Данный интерфейс определяет протокол взаимодействия с компонентой, при которм компоненте
    /// посылаются сигналы от клиента, в ответ на которые компонента меняет свойство <see cref="Completion"/>,
    /// данное свойство содержит в себе новую задачу, выполняемую компонентой и данное свойство
    /// может измениться только при получении нового сигнала от клиента.
    /// </para>
    /// <para>
    /// В дополнение к <see cref="Completion"/> компонента может определять другие свойства, в
    /// которых будет передаваться информация о результате выполнения операции.
    /// </para>
    /// <para>
    /// Особое внимание следует уделить реализации <see cref="IDisposable"/>, который по своей природе
    /// синхронный, данное правило безусловно можно нарушить, но тогда могут возникнуть проблемы с
    /// тем, что ресурсы еще не освободились, а ход программы продолжается, что приведет к ошибкам,
    /// например при попытке получить ресуср другим объектом, либо при заврешении программы.
    /// </para>
    /// <seealso href="https://blog.stephencleary.com/2013/01/async-oop-0-introduction.html"/>
    /// </remarks>
    public interface IAsyncComponent {
        /// <summary>
        /// The result of the last started operation. This property reflects
        /// only the result of the last started operation and therefore should
        /// change only if a new operation is initiated.
        /// </summary>
        Task Completion { get; }
    }
}