﻿using System;
using System.Diagnostics;
using Implab.Diagnostics;
using Implab.ServiceHost.Unity;
using Implab.Xml;
using Unity;
using Unity.Injection;

namespace Implab.Playground {

    public class Foo {
        public int IntValue { get; set; }

        public string StringValue { get; set; }

    }

    public class Container<T> {
        public Container() {

        }

        public Container(T instance) {
            Instance = instance;
        }

        public T Instance { get; set; }
    }

    public class Program {

        static void Main(string[] args) {
            var container = new UnityContainer();

            var listener = new SimpleTraceListener(Console.Out);
            Trace<ConfigurationContext>.TraceSource.Switch.Level = SourceLevels.All;
            Trace<ConfigurationContext>.TraceSource.Listeners.Add(listener);

            var c = new Container<int>();

            var cts = new ConfigurationContext();
            cts.AddNamespace("System");
            cts.AddNamespace("System.Collections.Generic");
            cts.AddNamespace("Implab.Playground");

            Console.WriteLine(c.GetType().FullName);

            cts.Resolve("Container{Int32}");
        }


    }
}
