﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Implab.Automaton {
    /// <summary>
    /// Dummy alphabet consists of integer numbers which are identical to their classes.
    /// </summary>
    public class DummyAlphabet : IAlphabet<int> {
        readonly int m_size;

        /// <summary>
        /// Creates a new dummy alphabet with given size.
        /// </summary>
        /// <param name="size">The size of the alphabet, must be greater then zero.</param>
        public DummyAlphabet(int size) {
            Safe.ArgumentAssert(size > 0);
            m_size = 0;
        }

        #region IAlphabet implementation

        public List<int>[] CreateReverseMap() {
            Enumerable.Range(0, m_size).ToArray();
        }

        public int Translate(int symbol) {
            Safe.ArgumentInRange(symbol, 0, m_size, "symbol");
            return symbol;
        }

        public bool Contains(int symbol) {
            Safe.ArgumentInRange(symbol, 0, m_size, "symbol");
            return true;
        }

        public int Count {
            get {
                return m_size;
            }
        }

        #endregion
    }
}

