﻿using System;

namespace Implab.Formats {
    public class ScannerContext<TTag> {
        public int[,] Dfa { get; private set; }
        public bool[] Final { get; private set; }
        public TTag[][] Tags { get; private set; }
        public int State { get; private set; }
        public int[] Alphabet { get; private set; }

        public ScannerContext(int[,] dfa, bool[] final, TTag[][] tags, int state, int[] alphabet) {
            Dfa = dfa;
            Final = final;
            Tags = tags;
            State = state;
            Alphabet = alphabet;
        }

        public bool Execute(TextScanner scanner, out TTag[] tag) {
            return scanner.ReadToken(Dfa, Final, Tags, State, Alphabet, out tag);
        }
    }
}

