﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    public class AltToken: BinaryToken {
        public AltToken(Token left, Token right)
            : base(left, right) {
        }

        public override void Accept(IVisitor visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }
        public override string ToString() {
            return String.Format(Right is BinaryToken ? "{0}|({1})" : "{0}|{1}", Left, Right);
        }
    }
}
