﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    public abstract class BinaryToken : Token {
        Token m_left;
        Token m_right;

        public Token Left {
            get { return m_left; }
        }

        public Token Right {
            get { return m_right; }
        }

        protected BinaryToken(Token left, Token right) {
            Safe.ArgumentNotNull(m_left = left, "left");
            Safe.ArgumentNotNull(m_right = right, "right");
        }
    }
}
