﻿using System;

namespace Implab.Automaton.RegularExpressions {
    public struct DFAStateDescriptorT<T> {
        public readonly bool final;

        public readonly int[] transitions;

        public readonly T[] tags;

        public DFAStateDescriptorT(int size, bool final, T[] tags) {
            Safe.ArgumentAssert(size >= 0, "size");
            this.final = final;
            this.tags = tags;

            transitions = new int[size];

            for (int i = 0; i < size; i++)
                transitions[i] = DFAConst.UNREACHABLE_STATE;
        }
    }
}

