﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Implab.Diagnostics.Interactive {
    public partial class TraceForm : Form {
        readonly Dictionary<int, Color> m_threadColors = new Dictionary<int,Color>();
        readonly Random m_rand = new Random();

        public event EventHandler PauseEvents;

        public event EventHandler ResumeEvents;

        public TraceForm() {
            InitializeComponent();
        }

        protected override void OnFormClosing(FormClosingEventArgs e) {
            base.OnFormClosing(e);
            if (!e.Cancel && e.CloseReason == CloseReason.UserClosing) {
                e.Cancel = true;
                Hide();
            }
        }

        public void AddTraceEvent(TraceViewItem item) {
            traceViewItemBindingSource.Add(item);
            eventsDataGrid.FirstDisplayedScrollingRowIndex = eventsDataGrid.RowCount - 1;
        }

        Color GetThreadColor(int thread) {
            Color result;
            if (!m_threadColors.TryGetValue(thread, out result)) {
                result = Color.FromArgb(m_rand.Next(4)*64, m_rand.Next(4)*64, m_rand.Next(4)*64);
                m_threadColors[thread] = result;
            }
            return result;
        }

        private void eventsDataGrid_CellFormatting(object sender, DataGridViewCellFormattingEventArgs e) {
            var data = (TraceViewItem)traceViewItemBindingSource[e.RowIndex];
            if (e.ColumnIndex == messageDataGridViewTextBoxColumn.Index)
                e.CellStyle.Padding = new Padding(data.Indent * 10,0,0,0);
            e.CellStyle.ForeColor = GetThreadColor(data.Thread);
        }
    }
}
