﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab
{
    public interface IPromise<T>: IPromise
    {

        new T Join();
        new T Join(int timeout);

        IPromise<T> Then(ResultHandler<T> success, ErrorHandler error);
        IPromise<T> Then(ResultHandler<T> success, ErrorHandler<T> error);
        IPromise<T> Then(ResultHandler<T> success);
        new IPromise<T> Error(ErrorHandler error);
        IPromise<T> Error(ErrorHandler<T> error);

        IPromise<T2> Map<T2>(ResultMapper<T,T2> mapper, ErrorHandler error);
        IPromise<T2> Map<T2>(ResultMapper<T, T2> mapper);

        IPromise<T2> Chain<T2>(ChainedOperation<T, T2> chained, ErrorHandler error);
        IPromise<T2> Chain<T2>(ChainedOperation<T, T2> chained);

        new IPromise<T> Cancelled(Action handler);
        new IPromise<T> Finally(Action handler);
        new IPromise<T> Anyway(Action handler);

    }
}
