﻿using System;

namespace Implab.Components {
    /// <summary>
    /// Initializable components are created and initialized in two steps, first we have create the component,
    /// then we have to complete it's creation by calling an <see cref="Initialize()"/> method. All parameters needed
    /// to complete the initialization must be passed before the calling <see cref="Initialize()"/>
    /// </summary>
    public interface IInitializable {
        /// <summary>
        /// Completes initialization.
        /// </summary>
        /// <remarks>
        /// <para>
        /// Normally virtual methods shouldn't be called from the constructor, due to the incomplete object state, but
        /// they can be called from this method. This method is also usefull when we constructing a complex grpah
        /// of components where cyclic references may take place.
        /// </para>
        /// <para>
        /// In asyncronous patterns <see cref="Initialize()"/> can be called
        /// to start initialization and the <see cref="IRunnable.Completion"/>
        /// property can be used to track operation completion.
        /// </para>
        /// </remarks>
        void Initialize();
    }
}

