﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    /// <summary>
    /// Интерфейс для определения ДКА, позволяет добавить состояния и определить переходы.
    /// </summary>
    public interface IDFADefinition {
        /// <summary>
        /// Добавляет состояние в автомат.
        /// </summary>
        /// <returns>Индекс добавленного состояния.</returns>
        int AddState();
        /// <summary>
        /// Добавляет конечное состояние с указанными метками, если метки не заданы, то
        /// добавленное состояние не будет конечным.
        /// </summary>
        /// <param name="tags">Метки состояния.</param>
        /// <returns>Индекс добавленного состояния.</returns>
        int AddState(int[] tags);
        /// <summary>
        /// Определяет переход между состояниями.
        /// </summary>
        /// <param name="s1">Исходное состояние.</param>
        /// <param name="s2">Конечное состояние.</param>
        /// <param name="input">Входной символ.</param>
        void DefineTransition(int s1, int s2, int input);
        /// <summary>
        /// Размер входного алфавита. 
        /// </summary>
        /// <remarks>
        /// Размер входного алфавита определяет количество возможных выходов из одного состояния. <see cref="IAlphabet{TSymbol}.Count"/> 
        /// </remarks>
        int AlphabetSize { get; }
    }
}
