﻿using System.Collections.Generic;
using System.Linq;
using Implab.Automaton;
using System;

namespace Implab.Formats {
    public class CharAlphabet: IndexedAlphabetBase<char> {

        public override int GetSymbolIndex(char symbol) {
            return symbol;
        }

        public IEnumerable<char> InputSymbols {
            get { return Enumerable.Range(char.MinValue, char.MaxValue).Cast<char>(); }
        }

        public CharMap CreateCharMap() {
            var map = new Dictionary<int, int>();

            int max = 0, min = char.MaxValue;
            foreach (var p in Mappings) {
                var index = GetSymbolIndex(p.Key);
                max = Math.Max(max, index);
                min = Math.Min(min, index);
                map[index] = p.Value;
            }

            var result = new int[max - min + 1];

            for (int i = 0; i < result.Length; i++)
                map.TryGetValue(min + i, out result[i]);

            return new CharMap((char)min, result);
        }
    }
}
