﻿namespace Implab.Automaton {
    public struct DFAStateDescriptior {
        public readonly bool final;
        public readonly int[] transitions;


        public DFAStateDescriptior(int[] transitions, bool final) {
            this.transitions = transitions;
            this.final = final;
        }

        public DFAStateDescriptior(int[] transitions) : this(transitions, false) {
        }

        public DFAStateDescriptior(int size, bool final) {
            Safe.ArgumentInRange(size, 0, int.MaxValue, "size");

            this.final = final;

            transitions = new int[size];

            for (int i = 0; i < size; i++)
                transitions[i] = DFAConst.UNREACHABLE_STATE;
        }
    }
}
