﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Diagnostics {
    /// <summary>
    /// Класс для публикации событий выполнения программы, события публикуются через <see cref="LogChannel{TraceEvent}"/>.
    /// Журнал трассировки отражает логический ход выполнения программы и существует всегда, поскольку тесно связан с 
    /// контекстом трассировки.
    /// </summary>
    public static class TraceLog {
        [Conditional("TRACE")]
        public static void StartLogicalOperation() {
            TraceContext.Instance.StartLogicalOperation();
        }

        [Conditional("TRACE")]
        public static void StartLogicalOperation(string name) {
            TraceContext.Instance.StartLogicalOperation(name);
        }

        [Conditional("TRACE")]
        public static void EndLogicalOperation() {
            TraceContext.Instance.EndLogicalOperation();
        }

        [Conditional("TRACE")]
        public static void TraceInformation(string format, params object[] arguments) {
            LogChannel<TraceEvent>.Default.LogEvent(TraceEvent.Create(TraceEventType.Information, format, arguments));
        }

        [Conditional("TRACE")]
        public static void TraceWarning(string format, params object[] arguments) {
            LogChannel<TraceEvent>.Default.LogEvent(TraceEvent.Create(TraceEventType.Warning, format, arguments));
        }

        [Conditional("TRACE")]
        public static void TraceError(string format, params object[] arguments) {
            LogChannel<TraceEvent>.Default.LogEvent(TraceEvent.Create(TraceEventType.Error, format, arguments));
        }

        [Conditional("TRACE")]
        public static void TraceError(Exception err) {
            TraceError("{0}", err);
        }
    }
}
