﻿namespace Implab.Diagnostics {
    public static class Extensions {
        public static IPromise<T> EndLogicalOperation<T>(this IPromise<T> promise) {
            Safe.ArgumentNotNull(promise, "promise");
            var op = TraceContext.Instance.DetachLogicalOperation();

            return promise.Then<T>(
                 x => {
                    TraceContext.Instance.EnterLogicalOperation(op,true);
                    TraceLog.TraceInformation("promise = {0}", x);
                    TraceLog.EndLogicalOperation();
                    TraceContext.Instance.Leave();
                    return x;
                },
                err =>{
                    TraceContext.Instance.EnterLogicalOperation(op,true);
                    TraceLog.TraceError("promise died {0}", err);
                    TraceLog.EndLogicalOperation();
                    TraceContext.Instance.Leave();
                    throw new TransientPromiseException(err);
                },
                () => {
                    TraceContext.Instance.EnterLogicalOperation(op,true);
                    TraceLog.TraceInformation("promise cancelled");
                    TraceLog.EndLogicalOperation();
                    TraceContext.Instance.Leave();
                }
            );
        }

        public static IPromise EndLogicalOperation(this IPromise promise) {
            Safe.ArgumentNotNull(promise, "promise");
            var op = TraceContext.Instance.DetachLogicalOperation();

            return promise.Anyway(() => {
                TraceContext.Instance.EnterLogicalOperation(op,true);
                TraceLog.EndLogicalOperation();
                TraceContext.Instance.Leave();
            });
        }
    }
}

