﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    /// <summary>
    /// Конечный символ расширенного регулярного выражения, при построении ДКА
    /// используется для определения конечных состояний.
    /// </summary>
    public class EndToken: Token {

        int m_tag;

        public EndToken(int tag) {
            m_tag = tag;
        }

        public EndToken()
            : this(0) {
        }

        public int Tag {
            get { return m_tag; }
        }
        
        public override void Accept(IVisitor visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }
        public override string ToString() {
            return "#";
        }
    }
}
