using System;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity
{
    public class SerializedParameterElement : InjectionParameterElement, ISerializedValue {
        [XmlAttribute("href")]
        public string Location { get; set; }

        [XmlAnyElement]
        public XmlElement[] Content { get; set; }

        public XmlReader GetReader() {
            if (!string.IsNullOrEmpty(Location))
                return XmlReader.Create(Location);
            if (Content != null && Content.Length > 0)
                return Content[0].CreateNavigator().ReadSubtree();

            throw new Exception("No content found, expected XML document");
        }

        internal override void Visit(InjectionValueBuilder builder) {
            builder.Visit(this);
        }
    }
}