using System;
using System.Linq;
using System.Text;

namespace Implab.ServiceHost.Unity {
    public class TypeReference {
        public string TypeName { get; set; }

        public string Namespace { get; set; }

        public TypeReference[] GenericParameters { get; set; }

        public bool IsArray { get; set; }

        public bool IsOpenGeneric {
            get {
                return GenericParameters!=null && GenericParameters.Contains(null);
            }
        }

        public bool IsGeneric {
            get {
                return GenericParameters != null && GenericParameters.Length > 0;
            }
        }

        public override string ToString() {
            var builder = new StringBuilder();

            if (!string.IsNullOrEmpty(Namespace)) {
                builder.Append(Namespace);
                builder.Append('.');
            }

            if (!string.IsNullOrEmpty(TypeName)) {
                builder.Append(TypeName);
            } else {
                builder.Append("__unnamed__");
            }

            if (GenericParameters != null && GenericParameters.Length > 0) {
                builder.Append('{');
                for(var i = 0; i < GenericParameters.Length; i++) {
                    if (i > 0)
                        builder.Append(',');
                    builder.Append(GenericParameters[i]);
                }
                builder.Append('}');
            }

            return builder.ToString();
        }
        public static TypeReference Parse(string text) {
            var parser = new TypeReferenceParser(text);
            return parser.Parse();
        }
    }
}