using System;
using System.Xml.Serialization;
using Unity.Lifetime;
using Unity.Registration;

namespace Implab.ServiceHost.Unity {

    [XmlRoot("register", Namespace = Schema.ContainerConfigurationNamespace)]
    public class RegisterElement : AbstractRegistration  {
        
        /// <summary>
        /// An optional type which is registered as a service in the container, must be assignable to <see cref="ProvidesType">.
        /// </summary>
        [XmlAttribute("mapTo")]
        public string MapToType { get; set; }


        [XmlElement("constructor", typeof(ConstructorInjectionElement))]
        [XmlElement("property", typeof(PropertyInjectionElement))]
        [XmlElement("method", typeof(MethodInjectionElement))]
        public AbstractInjectionElement[] Injectors { get; set; }

        public override void Visit(ContainerBuilder context) {
            context.Visit(this);
        }
    }
    
}