﻿using System;
using Implab.Diagnostics;
using Implab.Parallels;
using Implab;
using System.Collections.Generic;
using System.Collections.Concurrent;
using System.Threading;

namespace MonoPlay {
    class MainClass {
        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            var t1 = Environment.TickCount;

            const int reads = 100000;
            const int writes = 1000;
            const int readThreads = 8;
            const int writeThreads = 0;

            var l = new SharedLock();
            var st = new HashSet<int>();

            Action reader1 = () => {
                for (int i =0; i < reads; i++) {
                    try {
                        l.LockShared();
                        st.Contains(i % 1000);
                        Thread.Sleep(0);
                    } finally {
                        l.Release();
                    }
                }
            };

            Action reader2 = () => {
                for(var i = 0; i < reads; i++)
                    lock(st) {
                        st.Contains(i % 1000);
                        Thread.Sleep(0);
                    }
            };

            Action writer1 = () => {
                var rnd = new Random(Environment.TickCount);
                for (int i = 0; i < writes; i++) {
                    try {
                        l.LockExclusive();
                        st.Add(rnd.Next(1000));
                        //Thread.Sleep(1);
                    } finally {
                        l.Release();
                    }
                }
            };

            Action writer2 = () => {
                var rnd = new Random(Environment.TickCount);
                for (int i = 0; i < writes; i++) {
                    lock (st) {
                        st.Add(rnd.Next(1000));
                        //Thread.Sleep(1);
                    }
                }
            };



            var readers = new IPromise[readThreads];
            for (int i = 0; i < readThreads; i++)
                readers[i] = AsyncPool.RunThread(reader1);

            var writers = new IPromise[writeThreads];
            for (int i = 0; i < writeThreads; i++)
                writers[i] = AsyncPool.RunThread(writer1);


            new [] {
                readers.Bundle().On(() => Console.WriteLine("readers complete in {0} ms", Environment.TickCount - t1)),
                writers.Bundle().On(() => Console.WriteLine("writers complete in {0} ms", Environment.TickCount - t1))
            }.Bundle().Join();



            var t2 = Environment.TickCount;
            Console.WriteLine("done: {0} ms, {1:.00} Mb, {2} GC", t2 - t1, GC.GetTotalMemory(false) / (1024*1024), GC.CollectionCount(0) );

        }


    }
}
