﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    public class CDFADefinition : DFADefinitionBase {
        Alphabet m_alphabet;

        public Alphabet Alphabet {
            get { return m_alphabet; }
        }

        public override int AlphabetSize {
            get { return m_alphabet.Count; }
        }

        public CDFADefinition(Alphabet alphabet): base() {
            Safe.ArgumentNotNull(alphabet, "alphabet");
            m_alphabet = alphabet;
        }

        public CDFADefinition Optimize() {
            var optimized = new CDFADefinition(new Alphabet());

            Optimize(optimized, m_alphabet, optimized.Alphabet);
            return optimized;
        }

        public void PrintDFA() {
            PrintDFA(m_alphabet);
        }
    }
}
