﻿using System;

namespace Implab {
    public class ActionChainTask<T> : ActionChainTaskBase, IDeferred<T> {
        readonly Func<T, IPromise> m_task;

        public ActionChainTask(Func<T, IPromise> task, Func<Exception, IPromise> error, Func<Exception, IPromise> cancel, bool autoCancellable) : base(error,cancel, autoCancellable) {
            m_task = task;
        }

        public void Resolve(T value) {
            if (m_task != null && LockCancelation()) {
                try {
                    var p = m_task(value);
                    p.On(SetResult, HandleErrorInternal, SetCancelled);
                    CancellationRequested(p.Cancel);
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }

    }
}

