﻿using Implab;

namespace Implab.Automaton.RegularExpressions {
    /// <summary>
    /// Конечный символ расширенного регулярного выражения, при построении ДКА
    /// используется для определения конечных состояний.
    /// </summary>
    public class EndToken: Token {

        public override void Accept(IVisitor visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }
        public override string ToString() {
            return "#";
        }
    }
}
